/**
 * \file sdc_random.c
 *
 * \brief Convenience function for generation of buffers filled with
 *        random data.
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 * \author Philipp Hachtmann (phacht@de.adit-jv.com)
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#include <stdlib.h>

#include <private/sdc_arch.h>
#include <sdc_random.h>

/* Functions */
sdc_error_t sdc_random_gen_buffer (sdc_session_t *session, const size_t len, uint8_t **random_data)
{
    sdc_error_t retval = SDC_OK;
    uint8_t *random_data_tmp;

    if (!session)
        return SDC_SESSION_INVALID;

    if (!len || !random_data)
        return SDC_INVALID_PARAMETER;

    random_data_tmp = malloc(len);
    if (!random_data_tmp)
        return SDC_NO_MEM;

    retval = sdc_arch_random_gen(session, len, random_data_tmp);

    if (retval == SDC_OK)
        *random_data = random_data_tmp;
    else
        free(random_data_tmp);

    return retval;
}

sdc_error_t sdc_random_gen(sdc_session_t *session,
                           const size_t len,
                           uint8_t *random_data)
{
    if (!session)
        return SDC_SESSION_INVALID;

    if (!len || !random_data)
        return SDC_INVALID_PARAMETER;

    return sdc_arch_random_gen(session, len, random_data);
}
